/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!***************************************************************!*\
  !*** ./resources/js/design_1/parts/certificate_validation.js ***!
  \***************************************************************/
(function ($) {
  "use strict";

  $('body').on('click', '.js-submit-certificate-validation-form-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    var modalTitle = $this.attr("data-title");
    var $form = $this.closest('form');
    var action = $form.attr('action');
    var data = $form.serializeObject();
    $this.addClass('loadingbar').prop('disabled', true);
    $form.find('input').removeClass('is-invalid');
    $.post(action, data, function (result) {
      if (result) {
        Swal.fire({
          html: makeModalHtml(modalTitle, closeIcon, result.html, null),
          showCancelButton: false,
          showConfirmButton: false,
          customClass: {
            content: 'p-0 text-left'
          },
          width: '37rem',
          didOpen: function didOpen() {}
        });
      }
    }).fail(function (err) {
      var errors = err.responseJSON;
      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = $form.find('[name="' + key + '"]');
          element.addClass('is-invalid');
          element.closest('.form-group').find('.invalid-feedback').text(error[0]);
        });
      }
    }).always(function () {
      refreshCaptcha();
      $this.removeClass('loadingbar').prop('disabled', false);
    });
  });
})(jQuery);
/******/ })()
;